<?php 
session_start();

require("config/conn.php");
require("functions.php");
include("includes/header.php");
include("includes/topbar.php");
include("includes/sidebar.php");

session_regenerate_id(true);

if (!isset($_SESSION['AdminLoginId'])) {
    header("Location: index.php");
} 

?>



<main>
    <div class="container-fluid px-4">

        <h1 class="mt-4 dash-heading">Category</h1>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item active">Category</li>
        </ol>




        <div class="row my-4">
            <div class="col-12 add-category-box">
                <h1 class="category-heading">Add Category</h1>
                <div class="categort-add-container">
                    <form method="post" action="code.php" enctype="multipart/form-data" class="d-flex align-items-center flex-wrap">
                        <div class="mb-3 mr-2">
                            <label for="image" class="form-label">Image</label>
                            <input required name="image" type="file" class="form-control" id="image">

                        </div>
                        <div class="mb-3 mx-2">
                            <label for="title" class="form-label">Title</label>
                            <input required type="text" placeholder="Title" class="form-control" name="title" id="title">
                        </div>
                        <div class="mb-3 ">
                        <label for="title" class="form-label">Select Color</label>
                        <div class="d-flex align-items-center flex-wrap">
                        <div class="form-check">
                            <input class="form-check-input" name="color" type="radio" value="1" id="color">
                            <label class="form-check-label" style="background: #E9E7FF; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" name="color" type="radio" value="2" id="color">
                            <label class="form-check-label" style="background: #DAE8FF; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" name="color" type="radio" value="3" id="color">
                            <label class="form-check-label" style="background: #FFDEDE; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" name="color" type="radio" value="4" id="color">
                            <label class="form-check-label" style="background: #FFF7E0; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" name="color" type="radio" value="5" id="color">
                            <label class="form-check-label" style="background: #FDD3E7; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" name="color" type="radio" value="6" id="color">
                            <label class="form-check-label" style="background: #F7EAFF; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" name="color" type="radio" value="7" id="color">
                            <label class="form-check-label" style="background: #E0FCF9; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" name="color" type="radio" value="8" id="color">
                            <label class="form-check-label" style="background: #FEEFED; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
</div>

</div>
<button class="add-category-btn" name="add_category" type="submit">Add</button>
                        
                    </form>
                </div>
            </div>
        </div>

        <div class="row mb-4">

            <div class="user-table">

                <div class="useractioncontainer d-flex align-items-center justify-content-between">
                    <a herf="javascript:void(0)" onclick="delete_all()" class="delete-user-btn">Delete Selected
                        Category</a>

                    <div class="dropdown">
                        <a class="download-data-btn dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            Download
                        </a>

                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="export.php?export_category_csv=true">CSV</a></li>
                            <li><a class="dropdown-item" href="export.php?export_category_excel=true" >Excel</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <form method="post" id="frm">
                    <table id="example" class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th class="hide-sort"><input type="checkbox" onclick="select_all()" id="delete"></th>
                                <th class=" d-none"> <?= $row['id']; ?> </td>
                                <th>SR No.</th>
                                <th>Name</th>
                                <th>Icon</th>
                                <th>Color</th>
                                <th>Total Quizzes</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
            
            $sql = "SELECT * FROM `categories`";

            $query_run = mysqli_query($conn, $sql);

            if ($query_run):
                if (mysqli_num_rows($query_run) > 0):

                    $i = 1;

                    foreach ($query_run as $row):
                        switch ($row['colorCode']) {
                            case 1:
                                $color = "#E9E7FF";
                                break;
                            case 2:
                                $color = "#DAE8FF";
                                break;
                            case 3:
                                $color = "#FFDEDE";
                                break;
                            case 4:
                                $color = "#FFF7E0";
                                break;
                            case 5:
                                $color = "#FDD3E7";
                                break;
                            case 6:
                                $color = "#F7EAFF";
                                break;
                            case 7:
                                $color = "#E0FCF9";
                                break;
                            case 8:
                                $color = "#FEEFED";
                                break;
                            
                            default:
                                $color = "E9E7FF";
                                break;
                        }

                        if ($row['priority'] == 0) {
                            $class = 'make';
                            $url = 'pincat';
                        } else{
                            $class = 'unmake';
                            $url = 'unpin';
                        }
                        ?>



                            <tr id="box<?= $row['id']; ?>">
                                <td><input type="checkbox" name="checkbox1[]" value="<?= $row['id']; ?>"
                                        id="<?= $row['id']; ?>"></td>
                                        <td class="cat_id d-none"> <?= $row['id']; ?> </td>
                                <td>
                                    <?= $i; ?>
                                </td>
                                <td>
                                    <?= $row['name']; ?>
                                </td>
                                <td><img style="width: 50px; height: 50px;" src="<?= $row['icon']; ?>" alt="icon">
                                </td>
                               
                                <td>
                                    <div style="width: 20px; height: 20px; background: <?= $color; ?>"></div>
                                </td>
                                <td>
                                    <?= $row['totalQuizzes']; ?>
                                </td>
                                <td> 
                                    <div class="d-flex align-items-center">
                                        <a class="edit-user edit-btn"  href=""><i
                                                class="fa-solid fa-pen-to-square"></i></a>
                                                <button
                                        
                                        class="delete-user delete-cat" name="deleteUser" value="<?= $row['id']; ?>"><i class="fa-solid fa-trash"></i></button>
                                        <a class="<?= $class; ?>-cat"  href="code.php?<?= $url; ?>=<?= $row['id']; ?>"><i class="fa-sharp fa-solid fa-thumbtack"></i></a>
                                    </div>
                                </td>
                            </tr>


                            <?php

                        $i++;
                    endforeach;








                else:
                    echo "No Category Data";
                endif;
            else:
                echo "Some Error Occured";
            endif;
            
            
            
            ?>

                        </tbody>
                    </table>
                </form>


            </div>
        </div>




<!-- Modal -->
<div class="modal fade" id="editCategory" tabindex="-1" aria-labelledby="editCategoryLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="editCategoryLabel">Edit Category</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
          <form action="code.php" method="POST" enctype="multipart/form-data">
              <div class="mb-3">
                  <label for="catLabel" class="form-label">Icon</label>
                    <div class="img-container d-flex justify-content-center align-items-center mb-4">
                        <img alt="icon" id="icon" style="width: 100px; height: 100px;">
                    </div>
                  <input  type="file" class="form-control" id="category_image" class="category_image" name="category_image">
                  <input type="hidden" class="oldImage" name="oldImage">
                  <input type="hidden" class="id" name="id">
                </div>
              <div class="mb-3">
                  <label for="catLabel" class="form-label">Title</label>
                  <input required type="text" class="form-control" id="category_name" name="category_name" class="category_name">
                </div>
                <div class="mb-3 ">
                        <label for="title" class="form-label">Select Color</label>
                        <div class="d-flex align-items-center flex-wrap">
                        <div class="form-check">
                            <input class="c-1 form-check-input" name="color" type="radio" value="1" id="color">
                            <label class="form-check-label" style="background: #E9E7FF; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-2 form-check-input" name="color" type="radio" value="2" id="color">
                            <label class="form-check-label" style="background: #DAE8FF; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-3 form-check-input" name="color" type="radio" value="3" id="color">
                            <label class="form-check-label" style="background: #FFDEDE; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-4 form-check-input" name="color" type="radio" value="4" id="color">
                            <label class="form-check-label" style="background: #FFF7E0; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-5 form-check-input" name="color" type="radio" value="5" id="color">
                            <label class="form-check-label" style="background: #FDD3E7; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-6 form-check-input" name="color" type="radio" value="6" id="color">
                            <label class="form-check-label" style="background: #F7EAFF; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-7 form-check-input" name="color" type="radio" value="7" id="color">
                            <label class="form-check-label" style="background: #E0FCF9; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="c-8 form-check-input" name="color" type="radio" value="8" id="color">
                            <label class="form-check-label" style="background: #FEEFED; width: 20px; height: 20px;" for="radio">
                                
                            </label>
                        </div>
</div>

</div>
                
<button class="add-category-btn edit-categpory-btn" name="edit_category" type="submit">Save</button>

            </form>
        </div>
        <div class="modal-footer">
            <p class="mx-4">Total Quizzes <span class='totalquizzes'></span> </p>
        </div>
    </div>
</div>
</div>



    </div>


     <!-- Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="deleteModalLabel">Delete Category</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <form action="code.php" method="post">
      <div class="modal-body">
        <p>Are you sure to delete this category ?</p>
        <input type="hidden" name="del_id" class="delete-cat-id" id="del_id">
      </div>
      <div class="modal-footer d-flex justify-content-start">

        <button type="submit" class="btn btn-primary delButton" name="delCatButton">Yes! Delete</button>
    </div>
</form>
    </div>
  </div>
</div>


</main>









<?php 

include("includes/script.php");

?>


<script>
    <?php

    if (isset($_SESSION['status'])) {
    ?>
            swal("<?= $_SESSION['message']; ?>", {
                icon: "<?= $_SESSION['icon'] ?>",

            }
            );
    <?php
  unset($_SESSION['status']);
        unset($_SESSION['message']);
        unset($_SESSION['icon']);
    }

?>


</script>


<script>
        $(document).ready(function () {
            var table = $('#example').DataTable({
                language: {
                    searchPlaceholder: "Search Category"
                },
                columnDefs: [
                    {
                        targets: 0,
                        checkboxes: {
                            selectRow: true
                        }
                    }
                ],
                select: {
                    style: 'multi'
                },
                order: [[1, 'asc']]

            });

        });



</script>
<script>





    function select_all() {
        if (jQuery('#delete').prop("checked")) {
            jQuery('input[type=checkbox]').each(function (param) {
                jQuery('#' + this.id).prop('checked', true);
                // console.log(this.id);
            });
        } else {
            jQuery('input[type=checkbox]').each(function (param) {
                jQuery('#' + this.id).prop('checked', false);
                // console.log(this.id);
            });
        }

    }




    function delete_all() {

        swal({
            title: "Are you sure?",
            text: "Are You Sure To Delete Categories !",
            icon: "warning",
            buttons: ["Cancel", "Yes ! Delete"],
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete) {
                    jQuery.ajax({
                        type: "post",
                        url: "code.php",
                        data: jQuery("#frm").serialize(),
                        success: function (response) {

                            jQuery('input[type=checkbox]').each(function () {
                                if (jQuery('#' + this.id).prop("checked")) {
                                    jQuery('#box' + this.id).remove();
                                }
                                swal({
                                    title: "Categories Deleted Successfully",
                                    text: "Categories Deleted",
                                    icon: "success",
                                });
                            });
                        }
                    });
                } else {

                }
            });



    }
</script>

<script>
    $('.edit-btn').click(function (e) { 
        e.preventDefault();

        var cat_id = $(this).closest('tr').find('.cat_id').text();
        // console.log(cat_id);
        $.ajax({
            type: "POST",
            url: "code.php",
            data: {
                'checking_edit_btn': true,
                'cat_id': cat_id,
            },
            success: function (response) {
                // console.log(response);
                $.each(response, function (key, value) { 
                    // console.log(value['name']);
                    $("#category_name").val(value['name']);
                    $(".oldImage").val(value['icon']);
                    $(".id").val(value['id']);
                    $(".totalquizzes").text(value['totalQuizzes']);
                    $("#icon").attr('src', value['icon']);
                    
                    switch (value['colorCode']) {
                        case '1':
                        $('.c-1').prop('checked' , true);
                            break;
                    
                        case '2':
                        $('.c-2').prop('checked' , true);
                            break;
                    
                        case '3':
                        $('.c-3').prop('checked' , true);
                            break;
                    
                        case '4':
                        $('.c-4').prop('checked' , true);
                            break;
                    
                        case '5':
                        $('.c-5').prop('checked' , true);
                            break;
                    
                        case '6':
                        $('.c-6').prop('checked' , true);
                            break;
                    
                        case '7':
                        $('.c-7').prop('checked' , true);
                            break;
                    
                        case '8':
                        $('.c-8').prop('checked' , true);
                            break;
                    
                        default:
                        $('.c-1').prop('checked' , true);
                            break;
                    }
                });
                


                $('#editCategory').modal('show');
            }
        });
        
    });
</script>

<script>
    $(document).ready(function () {
        $('.delete-cat').click(function (e) {
            e.preventDefault();

            var id = $(this).val();
            // console.log(user_id);
            $('.delete-cat-id').val(id);
            $('#deleteModal').modal('show')
        });
    });

</script>

<?php

include("includes/footer.php");


?>